package JavaClient;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

import javax.swing.JFrame;
import java.awt.* ;
import java.awt.event.* ;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;


import javax.swing.* ;


public class JavaClient extends JFrame implements ActionListener, MouseListener {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	JTextField runTime, timeInterval;
	JPanel masterPane, p1, p2, Title;
	JLabel rTime, tInterval, textTitle, tempTitle, tempDisplay, timeTitle, timeDisplay;
	JButton start, end, pause;
	private JFrame frame = new JFrame("Client");


	//ButtonHandler handler;
	
	static java.net.Socket socket;
	static PrintWriter out;
	static BufferedReader in;
	int timeToRun, tempInterval;
	boolean cont = true;
	
	public static void main(String[] args) throws Exception {
		// TODO Auto-generated method stub
	
		JavaClient client = new JavaClient();
		client.setSize(600,360); // set to 375x300 window
		client.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		client.setVisible(true);
        client.connectToServer();
        client.recieveData();
	}
	
	void connectToServer() throws Exception {
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		boolean connected = false;
		while(connected == false){
			String serverIP = JOptionPane.showInputDialog(
					frame,
		            "Enter IP Address of the Server:",
		            JOptionPane.QUESTION_MESSAGE);
			if (serverIP == null)
				System.exit(0);
			String port = JOptionPane.showInputDialog(
					frame,
		            "Enter Port Number",
		            "Welcome to the Temperature Logger!",
		            JOptionPane.QUESTION_MESSAGE);
			if (port == null)
				System.exit(0);
			try{
			socket = new java.net.Socket(serverIP, Integer.parseInt(port));
			connected = true;
			} catch (java.net.ConnectException e){
				JOptionPane.showMessageDialog(null, "Could not establish connection, try again!");
			} catch (NumberFormatException e){
				JOptionPane.showMessageDialog(null, "Could not establish connection, try again!");
			}catch (java.net.SocketException e){
				JOptionPane.showMessageDialog(null, "Could not establish connection, try again!");
			}
		}
		
        out = new PrintWriter(socket.getOutputStream(), true);
        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
	}
	
	void recieveData() throws Exception {
		String[] tokens = {" ", " "};
		char[] ASCII = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'}; //represent HEX 0-F
		while (cont) {
			//tokens = (in.readLine().getBytes());
			try{
				tokens = in.readLine().split(",");
				if (tokens[1].charAt(0) == '#'){
					System.out.println("Average Change in temperature(F/s): " + tokens[2]);
					System.out.println("Average overall temperature(F): " + tokens[3]);
					System.out.println("Run Time: " + tokens[4]);
					tempTitle.setText("Average Change in Temperature(F/s) : " + tokens[3]);
					tempDisplay.setText("Average Overall Temperature(F): " + tokens[2]);
					timeTitle.setText("Run Time: " + tokens[4] + "s");
					timeDisplay.setText("COMPLETE!");
					start.setEnabled(false);
					pause.setEnabled(false);
					break;
				}
				else
				System.out.println(tokens[1] + " " + tokens[2]);
				
				/*   To find out what the strange "box" characters were
				System.out.print(" " +  ASCII[(readIn.charAt(0) >> 4)]);
				System.out.print(ASCII[(readIn.charAt(1) >> 4)]);
				System.out.print(ASCII[(readIn.charAt(2) >> 4)]);
				System.out.print(ASCII[(readIn.charAt(3) >> 4)]);
				System.out.println(ASCII[(readIn.charAt(4) >> 4)]);
					All five of them were '0'
				*/   

			} catch (java.net.SocketException e){
				JOptionPane.showMessageDialog(null, "Connection Closed");
			}
			timeDisplay.setText(tokens[1]);
			tempDisplay.setText(tokens[2]);
		}
		
		socket.close();
	}
	
	public JavaClient(){
		super("Temperature Logger");
		masterPane = new JPanel();
		masterPane.setLayout(new BoxLayout(masterPane, BoxLayout.Y_AXIS));
		masterPane.setBackground(Color.black);
		
        start = new JButton("Start");
        pause = new JButton("Pause");
        pause.setEnabled(false);
        
        start.addMouseListener(this);
        pause.addMouseListener(this);
        
        start.setPreferredSize(new Dimension(80, 40));
        pause.setPreferredSize(new Dimension(80, 40));
        
        Title = new JPanel();
        Title.setBackground(Color.red);
        
        p1 = new JPanel();
        p1.setBackground(Color.red);
        

        
        textTitle = new JLabel("Welcome to Temperature Logger 9000!");
        textTitle.setFont(new Font(textTitle.getName(), Font.PLAIN, 27));
        textTitle.setForeground(Color.white);
        Title.add(textTitle, BorderLayout.SOUTH);
        
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        p1.setLayout(gb);
        

        rTime =  new JLabel("Run Time(in seconds) : ");
        tInterval = new JLabel("Interval(in seconds) : ");
        rTime.setFont(new Font(textTitle.getName(), Font.PLAIN, 22));
        tInterval.setFont(new Font(textTitle.getName(), Font.PLAIN, 22));
        rTime.setForeground(Color.white);
        tInterval.setForeground(Color.white);
        
        runTime =  new JTextField("");
        timeInterval = new JTextField("");
        

        gc.insets=new Insets(10,0,0,0);
        gc.ipadx=0;
        gc.weightx = 0.25;
        gc.gridx=0;
        gc.gridy=1;
        gc.anchor=GridBagConstraints.EAST;
        p1.add(rTime,gc);


        gc.insets=new Insets(10,0,0,0);
        gc.ipadx=40;
        gc.weightx = 0.25;
        gc.gridx=1;
        gc.gridy=1;
        gc.anchor=GridBagConstraints.WEST;
        p1.add(runTime,gc);


        gc.insets=new Insets(10,0,0,0);
        gc.ipadx=0;
        gc.weightx = 0.25;
        gc.gridx=0;
        gc.gridy=2;
        gc.anchor=GridBagConstraints.EAST;
        p1.add(tInterval,gc);


        gc.insets=new Insets(10,0,0,0);
        gc.ipadx=40;
        gc.weightx = 0.25;
        gc.gridx=1;
        gc.gridy=2;
        gc.anchor=GridBagConstraints.WEST;
        p1.add(timeInterval,gc);

        gc.insets = new Insets(10,0,0,0);
        gc.ipadx = 0; 
        gc.weightx = 0.25;
        gc.gridx = 2;
        gc.gridy = 0;
        gc.anchor=GridBagConstraints.CENTER;
        p1.add(start,gc);

        gc.insets = new Insets(10,0,0,0);
        gc.ipadx = 0; 
        gc.weightx = 0.25;
        gc.gridx = 2;
        gc.gridy = 2;
        gc.anchor=GridBagConstraints.NORTH;
        p1.add(pause,gc);
        
        tempTitle = new JLabel("Temperature Reading (F)");
        tempDisplay = new JLabel("0.0");
        timeTitle = new JLabel("Time (Seconds)");
        timeDisplay = new JLabel("0.0");
        
        p2 = new JPanel();
        p2.setBackground(Color.black);
        p2.setLayout(new BoxLayout(p2, BoxLayout.Y_AXIS));
        
        tempTitle.setFont(new Font(tempTitle.getName(), Font.PLAIN, 24));
        tempDisplay.setFont(new Font(tempDisplay.getName(), Font.PLAIN, 24));
        timeTitle.setFont(new Font(timeTitle.getName(), Font.PLAIN, 25));
        timeDisplay.setFont(new Font(timeDisplay.getName(), Font.PLAIN, 24));
        
        tempTitle.setForeground(Color.white);
        tempDisplay.setForeground(Color.white);
        timeTitle.setForeground(Color.white);
        timeDisplay.setForeground(Color.white);
        
        tempTitle.setAlignmentX(Component.CENTER_ALIGNMENT);
        tempDisplay.setAlignmentX(Component.CENTER_ALIGNMENT);
        timeTitle.setAlignmentX(Component.CENTER_ALIGNMENT);
        timeDisplay.setAlignmentX(Component.CENTER_ALIGNMENT);
        
        p2.add(tempTitle);
        p2.add(tempDisplay);
        p2.add(timeTitle);
        p2.add(timeDisplay);
        
        masterPane.add(Title);
        masterPane.add(p1);
        masterPane.add(p2);
        
        add(masterPane, BorderLayout.NORTH);
        

	}
	

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
	
	}

	@Override
	public void mouseClicked(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		System.out.println("Button pressed");
		if (e.getSource().equals(start)){
			System.out.println("Start");
			if (start.getText().equals("Start")){
				start.setText("Stop");
				pause.setEnabled(true);	
				timeToRun = Integer.parseInt(runTime.getText());
				tempInterval = Integer.parseInt(timeInterval.getText());
				out.println(timeToRun + " " + tempInterval);
			}
			else
			{
				out.println("Stopn");
				pause.setEnabled(false);
				start.setEnabled(false);
				cont = false;
				
			}
		}
		if (e.getSource().equals(pause)){
			if (pause.getText().equals("Pause")){
				pause.setText("Resume");
				out.println("Pause");
			}
			else if (pause.getText().equals("Resume")){
				pause.setText("Pause");
				out.println("Resum");
			}
		}
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}
